extends Node
class_name Avatar

# Constants
const MOVEMENT_SPEED = 250.0
const COLORS = [Color.DARK_RED, Color.DARK_GREEN, Color.DARK_BLUE, Color.DARK_ORANGE]

# Variables
@onready var _avatarSprite: Sprite2D = $AvatarSprite as Sprite2D
@onready var _frameSprite: Sprite2D  = $FrameSprite as Sprite2D
var _targetPixelPos:Vector2
var _isMoving = false
var _isLocalClient = false
var _avatarColor = Color.WHITE

# Internal functions
func _ready() -> void:
	_avatarSprite.self_modulate = _avatarColor
	_frameSprite.visible = false

func _process(delta: float)->void:
	if (_isMoving):
		_moveAvatar(delta)
		
func _moveAvatar(delta: float)->void:
	var canWalk = delta * MOVEMENT_SPEED
	var deltaVec = _targetPixelPos - _avatarSprite.global_position
	var shallWalk = deltaVec.length()
	if (canWalk > shallWalk):
		_avatarSprite.global_position = _targetPixelPos
		_isMoving = false
		_frameSprite.visible = false
	else:
		var walkWay = deltaVec.normalized() * canWalk 
		_avatarSprite.global_position += walkWay

# External functions
func SetAvatarPosition(pixelPosX:int, pixelPosY:int)->void:
	_targetPixelPos = Vector2(pixelPosX, pixelPosY)
	_avatarSprite.global_position = Vector2(pixelPosX, pixelPosY)
	_isMoving = false
	_frameSprite.visible = false

func GetAvatarPosition()->Vector2:
		return _targetPixelPos

func SetAvatarTargetPosition(pixelPosX:float, pixelPosY:float)->void:
	_targetPixelPos = Vector2(pixelPosX, pixelPosY)
	_isMoving = true
	if _isLocalClient:
		_frameSprite.global_position = _targetPixelPos
		_frameSprite.visible = true
	else:
		_frameSprite.visible = false

func SetIdLabel(text:String)->void:
	var label = $AvatarSprite/IdLabel as Label
	label.text = text

func SetAvatarColor(colorId:int)->void:
	var index:int = colorId % COLORS.size()
	_avatarColor = COLORS[index]
	if (_avatarSprite):
		_avatarSprite.self_modulate = _avatarColor

func SetAvatarVisible(isVisible:bool):
	_frameSprite.visible = isVisible

func SetIsLocalClient(b:bool)->void:
	_isLocalClient = b
