extends Node
class_name Playfield

# Constants
const MAP_SIZE_X = 14
const MAP_SIZE_Y = 5
const FIELD_PIXELSIZE_XY = 64
const MAP_PIXELSIZE_X = MAP_SIZE_X * FIELD_PIXELSIZE_XY
const MAP_PIXELSIZE_Y = MAP_SIZE_Y * FIELD_PIXELSIZE_XY

# Variables
static var Instance:Playfield = null
@onready var PlayfieldBg:Sprite2D = $PlayfieldBg as Sprite2D

# Internal functions
func _ready() -> void:
	Instance = self

# External functions
func IsPixelPosInPlayfield(posX:float, posY:float)->bool:
	if (posX<PlayfieldBg.global_position.x) or (posX>(PlayfieldBg.global_position.x+MAP_PIXELSIZE_X)):
		return false
	if (posY<PlayfieldBg.global_position.y) or (posY>(PlayfieldBg.global_position.y+MAP_PIXELSIZE_Y)):
		return false
	return true

func GetFieldPixelPosFromIndex(indexX:int, indexY:int)->Vector2:
	if (indexX>=MAP_SIZE_X) or (indexX<0) or (indexY>=MAP_SIZE_Y) or (indexY<0):
		return Vector2.ZERO
	var pixelPosX = PlayfieldBg.global_position.x + FIELD_PIXELSIZE_XY * 0.5 + FIELD_PIXELSIZE_XY * indexX
	var pixelPosY = PlayfieldBg.global_position.y + FIELD_PIXELSIZE_XY * 0.5 + FIELD_PIXELSIZE_XY * indexY
	return Vector2(pixelPosX, pixelPosY)
	
func GetFieldIndexFromPixelPos(posX:float, posY:float)->Vector2i:
	var indexX = floori((posX - PlayfieldBg.global_position.x) / FIELD_PIXELSIZE_XY)
	var indexY = floori((posY - PlayfieldBg.global_position.y) / FIELD_PIXELSIZE_XY)
	if (indexX>=MAP_SIZE_X) or (indexX<0) or (indexY>=MAP_SIZE_Y) or (indexY<0):
		return Vector2i.ZERO
	return Vector2i(indexX, indexY)
