## Helper class for creating and reading custom app messages, used with mkRelay.
class_name mkAppMsg

static func ConstructMsg(msgId:int, data:Array)->PackedByteArray:
	var retArray:PackedByteArray = var_to_bytes(msgId)
	
	for oneValue in data:
		retArray.append_array(var_to_bytes(oneValue))
	return retArray

static func DeconstructMsg(byteData:PackedByteArray)->Array:
	var retArray:Array = []
	var byteCounter = 0
		
	while byteCounter < byteData.size():
		var tmp = byteData.decode_var(byteCounter)
		if (tmp == null):
			return []
		retArray.append(tmp)
		byteCounter += byteData.decode_var_size(byteCounter)
	return retArray
