extends Node
class_name mkRelayDevCerts

# ------------------------------------------------------------------------------
# Helper to create a self-signed certificate, to be used during local development
# Assign this script to a node and let it run once. It will create a self-signed
# certificate in the 'User Data Folder'
# For production, use a cert created by a CA like letsencrypt.org 

const KEY_FILE  = "user://mkRelayDev.key"
const CERT_FILE = "user://mkRelayDev.crt"
const HOSTNAME  = "localhost"
const ORG       = "mkRelayDev" 
const COUNTRY   = "DE"


func _ready() -> void:
	if ResourceLoader.exists(KEY_FILE) and ResourceLoader.exists(CERT_FILE):
		return
	print("mkRelayDevCerts: Creating key/certificates")
	var crypto:Crypto = Crypto.new()
	var key:CryptoKey = crypto.generate_rsa(4096)
	var issuer:String = "CN=" + HOSTNAME + ",O=" + ORG + ",C=" + COUNTRY
	var cert = crypto.generate_self_signed_certificate(key, issuer)
	key.save(KEY_FILE)
	cert.save(CERT_FILE)
